###  1. Introduction to Cloud Deployment Models

- Cloud deployment models define where cloud services are located and how they are managed.
- Resources can be located inside a company, with a cloud service provider, or a combination of both.
- Three most popular types: Public, Private, and Hybrid.

---

### 2. Private Cloud Deployment Model

#### Definition & Characteristics

- An in-house managed cloud.
- Resources are located within the company's firewall.
- Offers much more control and insight over the environment.

#### Reasons for Adoption

- Strict data security requirements (e.g., financial, government, healthcare industries).
- Need to keep sensitive information behind the company's firewall.

#### Cost & Management

- May not offer significant cost savings compared to traditional IT.
- Company remains responsible for IT staff, hardware, and operations.

#### Deployment & Support

- Can be deployed using platforms like OpenStack (open-source, large community).
- Companies can hire external firms to install and support private clouds, offering a "public cloud-like experience" within their firewall.

#### Security Responsibilities

- All security responsibilities typically lie within the company itself.
- If management is outsourced to a managed private cloud provider, that company assumes the security responsibilities that a public cloud provider would.

---

### 3. Public Cloud Deployment Model

#### Definition & Characteristics

- Cloud services hosted outside a company's walls by a third-party provider.
- Best option when there are no strict data security concerns.

#### Benefits

- Cost savings due to:
    - Lower number of required IT staff.
    - Reduced hardware purchase costs.
    - Lower operational costs.

#### Major Providers & Examples

- **IaaS/PaaS/XaaS providers:** Amazon Web Services (AWS), Google Cloud, Microsoft Azure, Alibaba Cloud, Dimension Data, Rackspace, OpenStack, IBM Cloud.
- **SaaS-focused providers:** Salesforce.com, WordPress, Dropbox.
- **Consumer examples:** Apple iCloud.

#### Security Responsibilities

- Security responsibilities are mainly shifted to the cloud service provider.
- However, the customer never eliminates all security responsibilities (e.g., secure utilization).

---

### 4. Hybrid Cloud Deployment Model

#### Definition & Characteristics

- Utilizes a combination of a private cloud (within the company firewall) and public cloud services.
- Resources are a mixture of in-house and external.

#### Use Cases

- Used when some operational data has strict security requirements, while other data/applications do not.

#### Security Responsibilities

- Security requirements vary significantly for each service (private vs. public components).
- It is critical for the customer to diligently track and understand their responsibilities versus the provider's responsibilities for each component.